package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/12/31
 * @description 进入直播间位置
 */
@Getter
public enum EnumInRoomLocation {

    /**
     *
     */
    UN_KNOWN((byte) 0, "未知"),
    PUSH((byte) 1, "小程序推送");

    private final byte code;
    private final String desc;

    EnumInRoomLocation(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isPush(Byte b) {
        return Objects.equals(PUSH.code, b);
    }
}
