package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/23
 * @description
 */
@Getter
public enum EnumLivePermission {

    UNKNOWN((byte) -1, "未知"),
    CAN_LIVE((byte) 0, "能创建直播"),
    CARD_NOT_FILL((byte) 1, "名片未完善"),
    IN_LIVING((byte) 2, "正在直播中"),
    ;

    private byte code;

    private String desc;

    EnumLivePermission(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumLivePermission getByCode(Byte code) {
        for (EnumLivePermission e : EnumLivePermission.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

}
