package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Getter
public enum EnumRecordStatus {

    UNKNOWN((byte) -1, "未知"),
    NOT_OPEN((byte) 0, "未公开"),
    OPEN((byte) 1, "公开"),
    ;

    private final byte code;

    private final String desc;

    EnumRecordStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumRecordStatus getByCode(Byte code) {
        for (EnumRecordStatus e : EnumRecordStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isNotOpen(Byte code) {
        return Objects.equals(NOT_OPEN.code, code);
    }

    public static boolean isOpen(Byte code) {
        return Objects.equals(OPEN.code, code);
    }
}
