package com.jiamai.live.api.enums;

import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/29
 * @description
 */
@Getter
public enum EnumVideoFormat {

    UNKNOWN((byte) 0, "未知"),
    M3U8((byte) 1, "m3u8"),
    MP4((byte) 2, "mp4"),
    ;

    private final byte code;

    private final String suffix;

    EnumVideoFormat(byte code, String suffix) {
        this.code = code;
        this.suffix = suffix;
    }

    public static EnumVideoFormat getByCode(Byte code) {
        for (EnumVideoFormat e : EnumVideoFormat.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static EnumVideoFormat getBySuffix(String url) {
        if (StringUtils.isBlank(url)) {
            return UNKNOWN;
        }

        String lowerCase = url.toLowerCase();
        for (EnumVideoFormat e : EnumVideoFormat.values()) {
            if (lowerCase.endsWith(e.suffix)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isM3U8(Byte code) {
        return Objects.equals(M3U8.getCode(), code);
    }

    public static boolean isMP4(Byte code) {
        return Objects.equals(MP4.getCode(), code);
    }
}
