package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Getter
public enum WatchEnum {
    /**
     * 观众累计观看时间切割
     */
    UN_KNOW((byte)-1,"",null,null),
    THREE_LESS((byte)0,"小于3分钟",0L,179L),
    THREE_TEN((byte)1,"3~10分钟",180L,599L),
    TEN_MORE((byte)2,"10分钟以上",600L,null),
    TEN_THIRD((byte)3,"10~30分钟",600L,1799L),
    THIRD_MORE((byte)4,"30分钟以上",1800L,null),
    THIRD_SIX((byte)5,"30~60分钟",1800L,3599L),
    SIX_MORE((byte)6,"60分钟以上",3600L,null),
    ;

    private byte type;
    private String msg;
    private Long min;
    private Long max;

    WatchEnum(byte type,String msg,Long min,Long max){
        this.type = type;
        this.msg = msg;
        this.min = min;
        this.max = max;
    }

    public static final Long T = 30L * 60L;
    public static final Long TS = 60L * 60L;

    /**
     * 根据code查内容
     */
    public static WatchEnum get(Byte code){
        if(code == null){
            return UN_KNOW;
        }
        for(WatchEnum watchEnum:values()){
            if(Objects.equals(watchEnum.getType(),code)){
                return watchEnum;
            }
        }
        return UN_KNOW;
    }

    /**
     * 时间区分
     * @param time 时间
     * @return
     */
    public static List<WatchEnum> chooseTime(Long time){
        List<WatchEnum> list = new ArrayList<>(5);
        list.add(THREE_LESS);
        list.add(THREE_TEN);
        if(time == null){
            return list;
        }
        //30分钟以内
        if(time< T){
            list.add(TEN_MORE);
            return list;
        }
        //60分钟以内
        if(time<TS){
            list.add(TEN_THIRD);
            list.add(THIRD_MORE);
            return list;
        }
        list.add(TEN_THIRD);
        list.add(THIRD_SIX);
        list.add(SIX_MORE);
        return list;
    }

    /**
     * 根据时间返回类型
     */
    public static byte getWatchType(Long liveTime,Long time){
        if(time == null){
            return UN_KNOW.getType();
        }
        List<WatchEnum> watchEnums = chooseTime(liveTime);
        for(WatchEnum watchEnum:watchEnums){
            if(watchEnum.getMax() == null){
                if(time >= watchEnum.getMin()){
                    return watchEnum.getType();
                }
                continue;
            }
            if(watchEnum.getMax() != null && watchEnum.getMin() != null){
                if(time >= watchEnum.getMin() && time <= watchEnum.getMax()){
                    return watchEnum.getType();
                }
            }
        }
        return UN_KNOW.getType();
    }
}
