package com.jiamai.live.api.enums;

/**
 * web socket 消息类型
 *
 * @author hong
 */
public enum WsMsgTypeEnum {

    SPOKE(100201, "弹幕"),
    NEW_VISITOR(100202, "有人来了"),
    IN_TIME_DATA(100203, "直播间实时数据"),
    BANNED(100204, "禁言标志"),
    SHARE(100205, "分享直播间"),
    START(100206, "直播开始"),
    NOTICE(100207, "管理员公告"),
    QUESTION(100208, "管理员提问"),
    END(100209, "直播结束"),
    BREAK(100210, "直播断开"),
    CONTINUE(100211, "直播继续"),
    ROOM_PERSON_CHANGE(100212, "直播间人数变化"),
    ROOM_COMMENT_CHANGE(100213, "直播间评论数变化"),
    ACTION(100214, "动作"),
    INTRODUCE_CHANGE(100215, "讲解商品变更"),
    TURN_CAMERA(100216, "切换摄像头"),
    ROOM_WATCH_COUNT_CHANGE(100217, "直播间人次变化"),
    KICKOFF(100218, "踢人"),
    REDPACK(100221, "主播发红包" ),
    CANCEL_REDPACK(100222, "主播取消红包"),
    START_GRAB_REDPACK(100224,"开始抢红包"),
    RAFFLE(100219,"抽奖"),
    CANCEL_RAFFLE(100220,"取消抽奖"),
    DRAW(100223,"开奖"),
    ROOM_PERSON_ONLINE_CHANGE(100234, "直播间人数变化"),
    LIVE_HOT_GOODS(100225, "直播间爆款商品变更"),
    LIKE(100226, "直播间点赞"),
    ANNOUNCEMENT_CHANGE(100228, "公告变更"),
    ADD_ORDER_BILL(100231, "加单/报单"),
    CREATE_ORDER_BILL(100232, "生成订货单"),
    NEXT_LIVE_MESSAGE_SUBSCRIBE(100230, "下场直播订阅"),
    WELCOME(100233, "欢迎直播间新用户"),
    REDPACK_PAY_FAIL(100227,"红包付款失败" ),
    REDPACK_DISTRIBUTION_COMPLETED(100240, "红包发放完成"),
    REDPACK_RECEIVE(100241, "用户领取红包"),
    ROOM_BARRAGE(100251, "直播间弹幕变化"),
    INIT_BARRAGE(100252, "直播间初始弹幕"),
    GOODS_CHANGE_REMIND(100242, "直播间商品切换提醒"),
    SHOW_SUBSCRIBE_BUTTON(100243, "显示订阅按钮"),
    USER_NEXT_LIVE_MESSAGE_SUBSCRIBE(100244, "用户下场直播订阅"),
    ASSISTANT_COMMENT_TEMPLATE(100245,"主播评论模板" ),
    AUDIENCE_FIRST_ENTRY_COMMENT_TEMPLATE(100246, "观众首次进入评论模板"),
    GENERAL_AUDIENCE_COMMENT_TEMPLATE(100247,"通用评论模板" ),
    LIVE_GOODS_UPDATE(100248,"商品更新" );

    private int type;
    private String desc;

    WsMsgTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
