package com.jiamai.live.api.enums;

/**
 * web socket 推送类型
 *
 * @author hong
 */
public enum WsSubscribeTypeEnum {

    LIVE_USER(1, "/user/live/%s/%s", 2, "发给指定用户"),
    LIVE_ALL_USER(2, "/user/live/%s", 1, "发给所有访客"),
    LIVE_ALL_ASSIST(3, "/assist/live/%s", 1, "发给所有助手"),
    LIVE_ALL(4, "/all/live/%s", 1, "发给所有人"),
    LIVE_ALL_LIVER(5, "/liver/live/%s", 1, "发给所有主播"),
    ;

    /**
     * 订阅类型
     */
    private Integer type;

    /**
     * 订阅地址
     */
    private String url;

    /**
     * 订阅地址参数数量
     */
    private Integer paramCount;

    /**
     * 描述
     */
    private String desc;

    WsSubscribeTypeEnum(Integer type, String url, Integer paramCount, String desc) {
        this.type = type;
        this.url = url;
        this.paramCount = paramCount;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getUrl() {
        return url;
    }

    public String getDestination(Object... params) {
        if (params == null || params.length < paramCount) {
            return "";
        }
        return String.format(url, params);
    }

    public static WsSubscribeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (WsSubscribeTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
