package com.jiamai.live.api.mq;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 包括用户询价，截图
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserActionEvent implements Serializable {
    /**
     * 用户ID
     */
    private Long userId;
    /**
     * 直播间ID
     */
    private Long liveRoomId;
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 类型 1-询价 2-截图
     */
    private Byte type;

    /**
     * 场景 1-直播 2-回放
     */
    private Byte space;

    /**
     * 截图时间
     */
    private Long screenShortTime;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 直播商品ID-询价用
     */
    private Long liveGoodsId;

    /**
     * 操作时间
     */
    private Date visitTime;

    /**
     * 请求ID
     */
    private String requestId;
}
