package com.jiamai.live.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.jiamai.live.api.dto.live.LiveRoomDto;
import com.jiamai.live.api.dto.live.LiveWatchDto;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/5/22
 * @description 直播观看相关Remote接口
 */
@AdvancedFeignClient
public interface RemoteLiveWatchService {

    /**
     * 清除心跳过期用户
     *
     * @param liveRoomId 直播间ID
     */
    void clearLiveExpireUser(Long liveRoomId);

    /**
     * 查询用户观看的直播间信息
     * @param userId 用户ID
     * @param merchantId 商户ID
     * @return liveRoomDto
     */
    List<LiveWatchDto> selectByMerchantUserWatch(Long userId, Long merchantId);

    /**
     * 用户在线人数推流
     */
    void pushLiveWatchPersonStatistical();

    /**
     * 用户观看直播间统计
     */
    Integer getLiveWatchCount(Long userId,Long liveRoomId);

}
