package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/9/1
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InviteQrCodeRequest extends Operator implements Serializable {

    @Min(value = 1, message = "直播间ID必须大于0")
    @NotNull(message = "直播间ID不能为空")
    @ApiModelProperty("直播间ID")
    private Long liveRoomId;

    @NotNull(message = "inviteType不能为空")
    @ApiModelProperty("邀请类型，1-主播，2-助手")
    private Byte inviteType;

    @ApiModelProperty("邀请人名称（前端忽略）")
    private String inviteUserName;

    @ApiModelProperty("邀请人头像（前端忽略）")
    private String inviteAvatarUrl;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

}
