package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 图片列表参数
 * @author xiachenhang
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PicListRequest  extends Operator implements Serializable {

    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    /**
     * 微信OpenId
     */
    private              String        openId;

    /**
     * 1直播内订阅 2直播外订阅
     */
    private              Integer        type;

    /**
     * 1直播内订阅 2直播外订阅
     */
    private              Long        merchantId;
}
