package com.jiamai.live.api.request;

import com.youqian.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = true)
public class RoomRecordRequest extends PageRequest implements Serializable {
    @Min(1)
    @NotNull
    @ApiModelProperty(value = "商户ID", required = true)
    private Long merchantId;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "是否可以回看")
    private Boolean canDirectional;
}
