package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/22
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SendPreCommentRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty("直播间ID")
    private Long liveRoomId;

    @NotBlank(message = "发送内容不能为空")
    @ApiModelProperty("评论内容")
    private String content;

    @ApiModelProperty("用户名称前端忽略")
    private String userName;

    @ApiModelProperty("手机号码前端忽略")
    private String mobile;

    @ApiModelProperty("头像前端忽略")
    private String avatarUrl;

}
