package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/6/2
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class WelcomeRequest extends Operator implements Serializable {

    @NotNull(message = "直播间ID为空")
    @Min(value = 1, message = "直播间ID必须大于0")
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @NotNull(message = "欢迎用户ID为空")
    @Min(value = 1, message = "欢迎用户ID必须大于0")
    @ApiModelProperty(value = "欢迎的用户ID", required = true)
    private Long welcomeUserId;

}
