package com.jiamai.live.api.result;

import com.youqian.api.response.AreaRatioResult;
import com.youqian.api.response.CustomerRatioResult;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播结束数据统计
 */
@Data
public class LiveBackEndResult implements Serializable {
    /**
     * 观看回放: 落地页/回放页
     */
    private Integer watchPv;
    /**
     * 观看人数
     */
    private Integer watchUv;
    /**
     * 观看小视频
     */
    private Integer watchShortVideoPv;
    /**
     * 人均观看时长
     */
    private String averageWatchTime;
    /**
     * 客户占比
     */
    private CustomerRatioResult customerRatio;
    /**
     * 地域占比
     */
    private List<AreaRatioResult> areaRatios;

}
