package com.jiamai.live.api.result;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/6/8
 * @description
 */
@Data
public class RoomRecordResult implements Serializable {

    @ApiModelProperty(value = "直播回放地址", required = true)
    private String recordUrl;

    /**
     * 商户头像
     */
    private String logo;

    /**
     * 商铺名
     */
    private String merchantName;

    /**
     * 开播时间
     */
    private String realOpenTime;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 是否关注
     */
    private Boolean whetherToFollow;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

}
