package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * @author youqian mybatis generator 
 * 2020-11-24
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveCommentTemplateDto implements Serializable {
    private static final long serialVersionUID = 16062300981961063L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long liveCommentTemplateId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 模板内容
     * max length = 255
     * not null default = null
     */
    private String templateContent;

    /**
     * 商户id
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间id
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 模板类型
1助手模板
2观众首次进入模板
3观众通用模板
     * not null default = 1
     */
    private Integer templateType;

    /**
     * 用户id
     * not null default = 0
     */
    private Long userId;

    /**
     * 显示顺序
     * not null default = 1
     */
    private Integer displayOrder;

    /**
     * 出现顺序
     * not null default = 1
     */
    private Integer appearanceOrder;

    /**
     * 显示的时间,单位(秒)
     * not null default = null
     */
    private Integer showTime;
}