package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播回放TS文件详情
 * @author youqian mybatis generator 
 * 2020-12-21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveRecordTsDto implements Serializable {
    private static final long serialVersionUID = 160853611254725L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 回放时间ID
     * not null default = 0
     */
    private Long liveRecordTsId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 现实开始时间
     * not null default = null
     */
    private Date startTime;

    /**
     * 现实结束时间
     * not null default = null
     */
    private Date endTime;

    /**
     * 相对总视频开始时间(单位秒)
     * not null default = 0.000
     */
    private BigDecimal tsSeek;

    /**
     * 持续时长(单位秒)
     * not null default = 0.000
     */
    private BigDecimal tsDuration;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;
}