package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播回看/短视频日志
 * @author youqian mybatis generator 
 * 2020-12-21
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveShortVideoLogDto implements Serializable {
    private static final long serialVersionUID = 16085331608672237L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播回看日志ID
     * not null default = 0
     */
    private Long liveShortVideoLogId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 日志类型
     * not null default = 0
     */
    private Byte logType;

    /**
     * 直播商品ID
     * not null default = 0
     */
    private Long liveGoodsId;

    /**
     * 日志开始时间
     */
    private Date beginTime;

    /**
     * 日志结束时间
     */
    private Date endTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}