package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播观看时长统计
 * @author youqian mybatis generator
 * 2020-09-18
 */
@Data
public class LiveWatchExtDto implements Serializable {
    private static final long serialVersionUID = 16004167492568611L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播观看时长ID
     * not null default = 0
     */
    private Long liveWatchExtId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 名称
     * max length = 300
     * not null default = 
     */
    private String userName;

    /**
     * 头像
     * max length = 300
     * not null default = 
     */
    private String avatarUrl;

    /**
     * 是否员工 0不是 1是
     * not null default = 0
     */
    private Byte isEmployee;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 累计观看时长
     * not null default = 0
     */
    private Long liveWatchTime;

    /**
     * 累计观看时长Str
     */
    private String liveWatchTimeStr;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 首次观看
     */
    private Date watchFirst;

    /**
     * 首次观看
     */
    private String watchFirstStr;

    /**
     * 切分类型-1:3分钟以下 2:3-10分钟
     * not null default = 0
     */
    private Byte watchType;

    /**
     * 邀请来源
     * not null default = 0
     */
    private Byte inviteSource;

    /**
     * 邀请来源
     * not null default = 0
     */
    private String inviteMsg;

    /**
     * 是否新访客
     * not null default = 0
     */
    private Byte firstVisitor;

    /**
     * 用户ID
     */
    private String userIp;

    /**
     * 用户所在省
     */
    private String userProvince;

    /**
     * 用户所在市
     */
    private String userCity;


    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}