package com.jiamai.weixin.api;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import com.jiamai.weixin.bean.datacube.article.ArticlesummaryResult;
import com.jiamai.weixin.bean.datacube.article.ArticletotalResult;
import com.jiamai.weixin.bean.datacube.article.UserreadResult;
import com.jiamai.weixin.bean.datacube.article.UsershareResult;
import com.jiamai.weixin.bean.datacube.getcardbizuininfo.BizuinInfo;
import com.jiamai.weixin.bean.datacube.getcardbizuininfo.BizuinInfoResult;
import com.jiamai.weixin.bean.datacube.getcardcardinfo.CardInfo;
import com.jiamai.weixin.bean.datacube.getcardcardinfo.CardInfoResult;
import com.jiamai.weixin.bean.datacube.getcardmembercardinfo.MemberCardInfo;
import com.jiamai.weixin.bean.datacube.getcardmembercardinfo.MemberCardInfoResult;
import com.jiamai.weixin.bean.datacube.interfaces.InterfacesummaryResult;
import com.jiamai.weixin.bean.datacube.upstreammsg.UpstreammsgResult;
import com.jiamai.weixin.bean.datacube.user.UsercumulateResult;
import com.jiamai.weixin.bean.datacube.user.UsersummaryResult;
import com.jiamai.weixin.bean.datacube.wxapp.RetaininfoResult;
import com.jiamai.weixin.bean.datacube.wxapp.SummarytrendResult;
import com.jiamai.weixin.bean.datacube.wxapp.UserportraitResult;
import com.jiamai.weixin.bean.datacube.wxapp.VisitdistributionResult;
import com.jiamai.weixin.bean.datacube.wxapp.VisitpageResult;
import com.jiamai.weixin.bean.datacube.wxapp.VisittrendResult;
import com.jiamai.weixin.client.LocalHttpClient;
import com.jiamai.weixin.util.JsonUtil;

import java.nio.charset.Charset;

/**
 * 数据统计
 * @author hong
 */
public class DataCubeAPI extends BaseAPI {

	/**
	 * 拉取卡券概况数据<br>
	 * 1. 查询时间区间需&lt;=62天，否则报错;  <br>
	 * 2. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 3. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param bizuinCube bizuinCube
	 * @return result
	 */
	public static BizuinInfoResult getCardBizuinInfo(String access_token, BizuinInfo bizuinCube) {
		return getCardBizuinInfo(access_token, JsonUtil.toJSONString(bizuinCube));
	}
	
	/**
	 * 拉取卡券概况数据<br>
	 * 1. 查询时间区间需&lt;=62天，否则报错；<br>
	 * 2. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 3. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param requestJson post完整的json
	 * @return result
	 */
	public static BizuinInfoResult getCardBizuinInfo(String access_token, String requestJson) {
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getcardbizuininfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,BizuinInfoResult.class);
	}
	
	/**
	 * 获取免费券数据<br>
	 * 1. 该接口目前仅支持拉取免费券（优惠券、团购券、折扣券、礼品券）的卡券相关数据，暂不支持特殊票券（电影票、会议门票、景区门票、飞机票）数据。<br>
	 * 2. 查询时间区间需&lt;=62天，否则报错；<br>
	 * 3. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 4. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param freeCardCube freeCardCube
	 * @return result
	 */
	public static CardInfoResult getCardCardInfo(String access_token, CardInfo freeCardCube) {
		return getCardCardInfo(access_token, JsonUtil.toJSONString(freeCardCube));
	}
	
	/**
	 * 获取免费券数据<br>
	 * 1. 该接口目前仅支持拉取免费券（优惠券、团购券、折扣券、礼品券）的卡券相关数据，暂不支持特殊票券（电影票、会议门票、景区门票、飞机票）数据。<br>
	 * 2. 查询时间区间需&lt;=62天，否则报错；<br>
	 * 3. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 4. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param requestJson post完整的json
	 * @return result
	 */
	public static CardInfoResult getCardCardInfo(String access_token, String requestJson) {
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getcardcardinfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,CardInfoResult.class);
	}
	
	
	/**
	 * 拉取会员卡数据<br>
	 * 1. 查询时间区间需&lt;=62天，否则报错；<br>
	 * 2. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 3. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param memberCardCube memberCardCube
	 * @return result
	 */
	public static MemberCardInfoResult getCardMemberCardInfo(String access_token, MemberCardInfo memberCardCube) {
		return getCardMemberCardInfo(access_token, JsonUtil.toJSONString(memberCardCube));
	}
	
	/**
	 * 拉取会员卡数据<br>
	 * 1. 查询时间区间需&lt;=62天，否则报错；<br>
	 * 2. 传入时间格式需严格参照示例填写如”2015-06-15”，否则报错；<br>
	 * 3. 该接口只能拉取非当天的数据，不能拉取当天的卡券数据，否则报错。<br>
	 * @param access_token access_token
	 * @param requestJson post完整的json
	 * @return result
	 */
	public static MemberCardInfoResult getCardMemberCardInfo(String access_token, String requestJson) {
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getcardmembercardinfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,MemberCardInfoResult.class);
	}
	
	
	//用户分析数据接口----------------------------------------------------------
	
	/**
	 * 获取用户增减数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UsersummaryResult getusersummary(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getusersummary")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UsersummaryResult.class);
	}
	
	/**
	 * 获取累计用户数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UsercumulateResult getusercumulate(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getusercumulate")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UsercumulateResult.class);
	}
	
	//图文分析数据接口----------------------------------------------------------
	
	/**
	 * 获取图文群发每日数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static ArticlesummaryResult getarticlesummary(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getarticlesummary")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,ArticlesummaryResult.class);
	}
	
	/**
	 * 获取图文群发总数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static ArticletotalResult getarticletotal(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getarticletotal")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,ArticletotalResult.class);
	}
	
	/**
	 * 获取图文统计数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UserreadResult getuserread(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getuserread")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UserreadResult.class);
	}
	
	/**
	 * 获取图文统计分时数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UserreadResult getuserreadhour(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getuserreadhour")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UserreadResult.class);
	}
	
	/**
	 * 获取图文分享转发数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UsershareResult getusershare(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getusershare")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UsershareResult.class);
	}
	
	/**
	 * 获取图文分享转发分时数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UsershareResult getusersharehour(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getusersharehour")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UsershareResult.class);
	}
	
	//消息分析数据接口----------------------------------------------------------
	
	/**
	 * 获取消息发送概况数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsg(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsg")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息分送分时数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsghour(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsghour")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息发送周数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsgweek(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsgweek")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息发送月数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsgmonth(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsgmonth")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息发送分布数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsgdist(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsgdist")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息发送分布周数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsgdistweek(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsgdistweek")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	/**
	 * 获取消息发送分布月数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UpstreammsgResult getupstreammsgdistmonth(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getupstreammsgdistmonth")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UpstreammsgResult.class);
	}
	
	//消息分析数据接口----------------------------------------------------------
	
	/**
	 * 获取接口分析数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static InterfacesummaryResult getinterfacesummary(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getinterfacesummary")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,InterfacesummaryResult.class);
	}
	
	/**
	 * 获取接口分析分时数据
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static InterfacesummaryResult getinterfacesummaryhour(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getinterfacesummaryhour")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,InterfacesummaryResult.class);
	}
	
	//-------------------------- 小程序
	
	/**
	 * 概况趋势	(小程序)
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static SummarytrendResult getweanalysisappiddailysummarytrend(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappiddailysummarytrend")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,SummarytrendResult.class);
	}
	
	/**
	 * 访问趋势 (小程序)<br>
	 * 日趋势
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static VisittrendResult getweanalysisappiddailyvisittrend(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappiddailyvisittrend")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,VisittrendResult.class);
	}
	
	/**
	 * 访问趋势 (小程序)<br>
	 * 周趋势
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static VisittrendResult getweanalysisappidweeklyvisittrend(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidweeklyvisittrend")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,VisittrendResult.class);
	}
	
	/**
	 * 访问趋势 (小程序)<br>
	 * 月趋势
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static VisittrendResult getweanalysisappidmonthlyvisittrend(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidmonthlyvisittrend")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,VisittrendResult.class);
	}
	
	/**
	 * 访问分布 (小程序)<br>
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static VisitdistributionResult getweanalysisappidvisitdistribution(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidvisitdistribution")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,VisitdistributionResult.class);
	}
	
	/**
	 * 访问留存 (小程序)<br>
	 * 日留存
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static RetaininfoResult getweanalysisappiddailyretaininfo(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappiddailyretaininfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,RetaininfoResult.class);
	}
	
	/**
	 * 访问留存 (小程序)<br>
	 * 周留存
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static RetaininfoResult getweanalysisappidweeklyretaininfo(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidweeklyretaininfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,RetaininfoResult.class);
	}
	
	/**
	 * 访问留存 (小程序)<br>
	 * 月留存
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static RetaininfoResult getweanalysisappidmonthlyretaininfo(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidmonthlyretaininfo")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,RetaininfoResult.class);
	}
	
	/**
	 * 访问页面 (小程序)
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static VisitpageResult getweanalysisappidvisitpage(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappidvisitpage")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,VisitpageResult.class);
	}
	
	/**
	 * 用户画像 (小程序)
	 * @param access_token access_token
	 * @param begin_date begin_date
	 * @param end_date end_date
	 * @return result
	 *
	 */
	public static UserportraitResult getweanalysisappiduserportrait(String access_token, String begin_date,String end_date) {
		String requestJson = String.format("{\"begin_date\":\"%s\",\"end_date\":\"%s\"}", begin_date,end_date);
		HttpUriRequest httpUriRequest = RequestBuilder.post()
                                                      .setHeader(jsonHeader)
                                                      .setUri(BASE_URI+"/datacube/getweanalysisappiduserportrait")
                                                      .addParameter(PARAM_ACCESS_TOKEN, API.accessToken(access_token))
                                                      .setEntity(new StringEntity(requestJson, Charset.forName("utf-8")))
                                                      .build();
		return LocalHttpClient.executeJsonResult(httpUriRequest,UserportraitResult.class);
	}
	
}
