/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.weixin.api;

import com.jiamai.weixin.api.API;
import com.jiamai.weixin.api.BaseAPI;
import com.jiamai.weixin.bean.BaseResult;
import com.jiamai.weixin.bean.comment.CommentList;
import com.jiamai.weixin.bean.comment.CommentListResult;
import com.jiamai.weixin.bean.comment.Params;
import com.jiamai.weixin.bean.comment.ReplyAdd;
import com.jiamai.weixin.client.LocalHttpClient;
import com.jiamai.weixin.util.JsonUtil;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class CommentAPI
extends BaseAPI {
    public static BaseResult open(String access_token, Long msg_data_id, Integer index) {
        String json = String.format("{\"msg_data_id\":%d,\"index\":%d}", msg_data_id, index == null ? 0 : index);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/open").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult close(String access_token, Long msg_data_id, Integer index) {
        String json = String.format("{\"msg_data_id\":%d,\"index\":%d}", msg_data_id, index == null ? 0 : index);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/close").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static CommentListResult list(String access_token, CommentList commentList) {
        String json = JsonUtil.toJSONString(commentList);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, CommentListResult.class);
    }

    public static BaseResult markelect(String access_token, Params markelect) {
        String json = JsonUtil.toJSONString(markelect);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/markelect").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult unmarkelect(String access_token, Params unmarkelect) {
        String json = JsonUtil.toJSONString(unmarkelect);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/unmarkelect").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult delete(String access_token, Params delete) {
        String json = JsonUtil.toJSONString(delete);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/delete").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult replyAdd(String access_token, ReplyAdd replyAdd) {
        String json = JsonUtil.toJSONString(replyAdd);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/reply/add").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult replyDelete(String access_token, Params delete) {
        String json = JsonUtil.toJSONString(delete);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/comment/reply/delete").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }
}

