/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.api;

import com.jiamai.winxin.api.API;
import com.jiamai.winxin.api.BaseAPI;
import com.jiamai.winxin.api.CommentAPI;
import com.jiamai.winxin.bean.BaseResult;
import com.jiamai.winxin.bean.component.ApiGetAuthorizerInfoResult;
import com.jiamai.winxin.bean.component.ApiGetAuthorizerListResult;
import com.jiamai.winxin.bean.component.ApiQueryAuthResult;
import com.jiamai.winxin.bean.component.AuthorizerAccessToken;
import com.jiamai.winxin.bean.component.AuthorizerOption;
import com.jiamai.winxin.bean.component.ComponentAccessToken;
import com.jiamai.winxin.bean.component.PreAuthCode;
import com.jiamai.winxin.client.LocalHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAPI
extends BaseAPI {
    private static Logger logger = LoggerFactory.getLogger(CommentAPI.class);

    public static String componentloginpage(String component_appid, String pre_auth_code, String redirect_uri) {
        return ComponentAPI.componentloginpage(component_appid, pre_auth_code, redirect_uri, null);
    }

    public static String componentloginpage(String component_appid, String pre_auth_code, String redirect_uri, String auth_type) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://mp.weixin.qq.com/cgi-bin/componentloginpage?").append("component_appid=").append(component_appid).append("&pre_auth_code=").append(pre_auth_code).append("&redirect_uri=").append(URLEncoder.encode(redirect_uri, "utf-8"));
            if (auth_type != null) {
                sb.append("&auth_type=").append(auth_type);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static String safeBindcomponent(String component_appid, String pre_auth_code, String redirect_uri, String auth_type) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://mp.weixin.qq.com/safe/bindcomponent?").append("action=").append("bindcomponent").append("&auth_type=").append(auth_type).append("&no_scan=").append("1").append("&component_appid=").append(component_appid).append("&pre_auth_code=").append(pre_auth_code).append("&redirect_uri=").append(URLEncoder.encode(redirect_uri, "utf-8"));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static ComponentAccessToken api_component_token(String component_appid, String component_appsecret, String component_verify_ticket) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\" ,\"component_appsecret\": \"%2$s\",\"component_verify_ticket\": \"%3$s\"}", component_appid, component_appsecret, component_verify_ticket);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_component_token").setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ComponentAccessToken.class);
    }

    public static PreAuthCode api_create_preauthcode(String component_access_token, String component_appid) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\"}", component_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, PreAuthCode.class);
    }

    public static ApiQueryAuthResult api_query_auth(String component_access_token, String component_appid, String authorization_code) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorization_code\":\"%2$s\"}", component_appid, authorization_code);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_query_auth").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ApiQueryAuthResult.class);
    }

    public static AuthorizerAccessToken api_authorizer_token(String component_access_token, String component_appid, String authorizer_appid, String authorizer_refresh_token) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"authorizer_refresh_token\":\"%3$s\"}", component_appid, authorizer_appid, authorizer_refresh_token);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, AuthorizerAccessToken.class);
    }

    public static ApiGetAuthorizerInfoResult api_get_authorizer_info(String component_access_token, String component_appid, String authorizer_appid) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\"}", component_appid, authorizer_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ApiGetAuthorizerInfoResult.class);
    }

    public static AuthorizerOption api_get_authorizer_option(String component_access_token, String component_appid, String authorizer_appid, String option_name) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"option_name\":\"%3$s\"}", component_appid, authorizer_appid, option_name);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_option").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, AuthorizerOption.class);
    }

    public static BaseResult api_set_authorizer_option(String component_access_token, String component_appid, String authorizer_appid, String option_name, String option_value) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"option_name\":\"%3$s\",\"option_value\":\"%4$s\"}", component_appid, authorizer_appid, option_name, option_value);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_set_authorizer_option").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult clear_quota(String component_access_token, String component_appid) {
        String json = String.format("{\"component_appid\":\"%s\"}", component_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/clear_quota").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static ApiGetAuthorizerListResult api_get_authorizer_list(String component_access_token, String component_appid, String offset, String count) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"offset\":\"%2$s\",\"count\":\"%3$s\"}", component_appid, offset, count);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_list").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ApiGetAuthorizerListResult.class);
    }
}

