/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.api;

import com.jiamai.winxin.api.API;
import com.jiamai.winxin.api.BaseAPI;
import com.jiamai.winxin.bean.media.Media;
import com.jiamai.winxin.bean.media.MediaGetResult;
import com.jiamai.winxin.bean.media.MediaType;
import com.jiamai.winxin.bean.media.UploadimgResult;
import com.jiamai.winxin.bean.message.Article;
import com.jiamai.winxin.bean.message.Uploadvideo;
import com.jiamai.winxin.client.BytesOrJsonResponseHandler;
import com.jiamai.winxin.client.LocalHttpClient;
import com.jiamai.winxin.util.JsonUtil;
import com.jiamai.winxin.util.StreamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaAPI
extends BaseAPI {
    private static Logger logger = LoggerFactory.getLogger(MediaAPI.class);

    public static Media mediaUpload(String access_token, MediaType mediaType, File media) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        FileBody bin = new FileBody(media);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    public static Media mediaUpload(String access_token, MediaType mediaType, InputStream inputStream) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        byte[] data = null;
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp." + mediaType.fileSuffix()).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Media mediaUpload(String access_token, MediaType mediaType, URI uri) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/upload");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), "temp." + mediaType.fileSuffix()).addTextBody("access_token", API.accessToken(access_token)).addTextBody("type", mediaType.uploadType()).build();
            httpPost.setEntity(reqEntity);
            Media media = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
            return media;
        }
        catch (UnsupportedCharsetException e) {
            logger.error("", (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error("", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static MediaGetResult mediaGet(String access_token, String media_id, boolean use_http) {
        String http_s = use_http ? "https://api.weixin.qq.com".replace("https", "http") : "https://api.weixin.qq.com";
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri(http_s + "/cgi-bin/media/get").addParameter("access_token", API.accessToken(access_token)).addParameter("media_id", media_id).build();
        return LocalHttpClient.execute(httpUriRequest, BytesOrJsonResponseHandler.createResponseHandler(MediaGetResult.class));
    }

    public static MediaGetResult mediaGet(String access_token, String media_id) {
        return MediaAPI.mediaGet(access_token, media_id, false);
    }

    public static MediaGetResult mediaGetJssdk(String access_token, String media_id) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/cgi-bin/media/get/jssdk").addParameter("access_token", API.accessToken(access_token)).addParameter("media_id", media_id).build();
        return LocalHttpClient.execute(httpUriRequest, BytesOrJsonResponseHandler.createResponseHandler(MediaGetResult.class));
    }

    public static UploadimgResult mediaUploadimg(String access_token, File media) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        FileBody bin = new FileBody(media);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).addTextBody("access_token", API.accessToken(access_token)).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
    }

    public static UploadimgResult mediaUploadimg(String access_token, InputStream inputStream) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        byte[] data = null;
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp.jpg").addTextBody("access_token", API.accessToken(access_token)).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadimgResult mediaUploadimg(String access_token, URI uri) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/uploadimg");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), UUID.randomUUID().toString() + ".jpg").addTextBody("access_token", API.accessToken(access_token)).build();
            httpPost.setEntity(reqEntity);
            UploadimgResult uploadimgResult = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, UploadimgResult.class);
            return uploadimgResult;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static Media mediaUploadnews(String access_token, List<Article> articles) {
        String str = JsonUtil.toJSONString(articles);
        String messageJson = "{\"articles\":" + str + "}";
        return MediaAPI.mediaUploadnews(access_token, messageJson);
    }

    public static Media mediaUploadnews(String access_token, String messageJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/media/uploadnews").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(messageJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Media.class);
    }

    public static Media mediaUploadvideo(String access_token, Uploadvideo uploadvideo) {
        String messageJson = JsonUtil.toJSONString(uploadvideo);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/media/uploadvideo").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(messageJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Media.class);
    }
}

