/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.api;

import com.jiamai.winxin.api.API;
import com.jiamai.winxin.api.BaseAPI;
import com.jiamai.winxin.bean.BaseResult;
import com.jiamai.winxin.bean.media.MediaType;
import com.jiamai.winxin.bean.semantic.queryrecoresultfortext.QueryrecoresultfortextResult;
import com.jiamai.winxin.bean.semantic.semproxy.SemproxySearch;
import com.jiamai.winxin.bean.semantic.semproxy.SemproxySearchResult;
import com.jiamai.winxin.bean.semantic.translatecontent.TranslatecontentResult;
import com.jiamai.winxin.client.LocalHttpClient;
import com.jiamai.winxin.util.JsonUtil;
import com.jiamai.winxin.util.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticAPI
extends BaseAPI {
    private static Logger logger = LoggerFactory.getLogger(SemanticAPI.class);

    public static SemproxySearchResult semproxySearch(String accessToken, SemproxySearch semproxySearch) {
        return SemanticAPI.semproxySearch(accessToken, JsonUtil.toJSONString(semproxySearch));
    }

    public static SemproxySearchResult semproxySearch(String accessToken, String postData) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/semantic/semproxy/search").addParameter("access_token", API.accessToken(accessToken)).setEntity((HttpEntity)new StringEntity(postData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SemproxySearchResult.class);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, File voice) {
        return SemanticAPI.addvoicetorecofortext(accessToken, voiceId, null, voice);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, InputStream inputStream) {
        return SemanticAPI.addvoicetorecofortext(accessToken, voiceId, null, inputStream);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, URI uri) {
        return SemanticAPI.addvoicetorecofortext(accessToken, voiceId, null, uri);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, String lang, File voice) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/addvoicetorecofortext");
        FileBody bin = new FileBody(voice);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin).addTextBody("access_token", API.accessToken(accessToken)).addTextBody("format", MediaType.voice_mp3.fileSuffix()).addTextBody("voice_id", voiceId).addTextBody("lang", lang == null || lang.isEmpty() ? "zh_CN" : lang).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, BaseResult.class);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, String lang, InputStream inputStream) {
        byte[] data;
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/addvoicetorecofortext");
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp." + MediaType.voice_mp3.fileSuffix()).addTextBody("access_token", API.accessToken(accessToken)).addTextBody("format", MediaType.voice_mp3.fileSuffix()).addTextBody("voice_id", voiceId).addTextBody("lang", lang == null || lang.isEmpty() ? "zh_CN" : lang).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, BaseResult.class);
    }

    public static BaseResult addvoicetorecofortext(String accessToken, String voiceId, String lang, URI uri) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/addvoicetorecofortext");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), "temp." + MediaType.voice_mp3.fileSuffix()).addTextBody("access_token", API.accessToken(accessToken)).addTextBody("format", MediaType.voice_mp3.fileSuffix()).addTextBody("voice_id", voiceId).addTextBody("lang", lang == null || lang.isEmpty() ? "zh_CN" : lang).build();
            httpPost.setEntity(reqEntity);
            BaseResult baseResult = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, BaseResult.class);
            return baseResult;
        }
        catch (IOException | UnsupportedCharsetException | ParseException e) {
            logger.error("", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public static QueryrecoresultfortextResult queryrecoresultfortext(String accessToken, String voiceId) {
        return SemanticAPI.queryrecoresultfortext(accessToken, voiceId, null);
    }

    public static QueryrecoresultfortextResult queryrecoresultfortext(String accessToken, String voiceId, String lang) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/cgi-bin/media/voice/queryrecoresultfortext").addParameter("access_token", API.accessToken(accessToken)).addParameter("voice_id", voiceId).addParameter("lang", lang == null || lang.isEmpty() ? "zh_CN" : lang).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, QueryrecoresultfortextResult.class);
    }

    public static TranslatecontentResult translatecontent(String accessToken, String lfrom, String lto, File content, String charsetName) {
        byte[] data;
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/translatecontent");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(content), charsetName));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            data = sb.toString().getBytes("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp.txt").addTextBody("access_token", API.accessToken(accessToken)).addTextBody("lfrom", lfrom).addTextBody("lto", lto).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, TranslatecontentResult.class);
    }

    public static TranslatecontentResult translatecontent(String accessToken, String lfrom, String lto, InputStream inputStream, String charsetName) {
        byte[] data;
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/translatecontent");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charsetName));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            data = sb.toString().getBytes("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp.txt").addTextBody("access_token", API.accessToken(accessToken)).addTextBody("lfrom", lfrom).addTextBody("lto", lto).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, TranslatecontentResult.class);
    }

    public static TranslatecontentResult translatecontent(String accessToken, String lfrom, String lto, String content) {
        byte[] data;
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/media/voice/translatecontent");
        try {
            data = content.getBytes("UTF-8");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp.txt").addTextBody("access_token", API.accessToken(accessToken)).addTextBody("lfrom", lfrom).addTextBody("lto", lto).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, TranslatecontentResult.class);
    }
}

