/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.bean.xmlmessage;

import com.jiamai.winxin.aes.AesException;
import com.jiamai.winxin.aes.WXBizMsgCrypt;
import com.jiamai.winxin.bean.message.message.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XMLMessage
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(XMLMessage.class);
    private static final long serialVersionUID = 8901661274548077509L;
    protected String toUserName;
    protected String fromUserName;
    protected String msgType;

    protected XMLMessage(String toUserName, String fromUserName, String msgType) {
        this.toUserName = toUserName;
        this.fromUserName = fromUserName;
        this.msgType = msgType;
    }

    public abstract String subXML();

    public abstract Message convert();

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        sb.append("<ToUserName><![CDATA[" + this.toUserName + "]]></ToUserName>");
        sb.append("<FromUserName><![CDATA[" + this.fromUserName + "]]></FromUserName>");
        sb.append("<CreateTime>" + System.currentTimeMillis() / 1000L + "</CreateTime>");
        sb.append("<MsgType><![CDATA[" + this.msgType + "]]></MsgType>");
        sb.append(this.subXML());
        sb.append("</xml>");
        return sb.toString();
    }

    public boolean outputStreamWrite(OutputStream outputStream) {
        try {
            outputStream.write(this.toXML().getBytes("utf-8"));
            outputStream.flush();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean outputStreamWrite(OutputStream outputStream, WXBizMsgCrypt bizMsgCrypt) {
        if (bizMsgCrypt != null) {
            try {
                String outputStr = bizMsgCrypt.encryptMsg(this.toXML(), System.currentTimeMillis() + "", UUID.randomUUID().toString());
                outputStream.write(outputStr.getBytes("utf-8"));
                outputStream.flush();
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
                return false;
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                return false;
            }
            catch (AesException e) {
                logger.error("", (Throwable)e);
                return false;
            }
            return true;
        }
        return this.outputStreamWrite(outputStream);
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public String getMsgType() {
        return this.msgType;
    }
}

