/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.support;

import com.jiamai.winxin.api.TokenAPI;
import com.jiamai.winxin.bean.token.Token;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger logger = LoggerFactory.getLogger(TokenManager.class);
    private static ScheduledExecutorService scheduledExecutorService;
    private static Map<String, String> tokenMap;
    private static Map<String, ScheduledFuture<?>> futureMap;
    private static int poolSize;
    private static boolean daemon;
    private static String firestAppid;

    private static void initScheduledExecutorService() {
        logger.info("daemon:{},poolSize:{}", (Object)daemon, (Object)poolSize);
        scheduledExecutorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread thread = Executors.defaultThreadFactory().newThread(arg0);
                thread.setDaemon(daemon);
                return thread;
            }
        });
    }

    public static void setPoolSize(int poolSize) {
        TokenManager.poolSize = poolSize;
    }

    public static void setDaemon(boolean daemon) {
        TokenManager.daemon = daemon;
    }

    public static void init(String appid, String secret) {
        TokenManager.init(appid, secret, 0, 7080);
    }

    public static void init(final String appid, final String secret, int initialDelay, int delay) {
        if (scheduledExecutorService == null) {
            TokenManager.initScheduledExecutorService();
        }
        if (firestAppid == null) {
            firestAppid = appid;
        }
        if (futureMap.containsKey(appid)) {
            futureMap.get(appid).cancel(true);
        }
        if (initialDelay == 0) {
            TokenManager.doRun(appid, secret);
        }
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TokenManager.doRun(appid, secret);
            }
        }, initialDelay == 0 ? (long)delay : (long)initialDelay, delay, TimeUnit.SECONDS);
        futureMap.put(appid, scheduledFuture);
        logger.info("appid:{}", (Object)appid);
    }

    private static void doRun(String appid, String secret) {
        try {
            Token token = TokenAPI.token(appid, secret);
            tokenMap.put(appid, token.getAccess_token());
            logger.info("ACCESS_TOKEN refurbish with appid:{}", (Object)appid);
        }
        catch (Exception e) {
            logger.error("ACCESS_TOKEN refurbish error with appid:{}", (Object)appid);
            logger.error("", (Throwable)e);
        }
    }

    public static void destroyed() {
        scheduledExecutorService.shutdownNow();
        logger.info("destroyed");
    }

    public static void destroyed(String appid) {
        if (futureMap.containsKey(appid)) {
            futureMap.get(appid).cancel(true);
            logger.info("destroyed appid:{}", (Object)appid);
        }
    }

    public static String getToken(String appid) {
        return tokenMap.get(appid);
    }

    public static String getDefaultToken() {
        return tokenMap.get(firestAppid);
    }

    static {
        tokenMap = new ConcurrentHashMap<String, String>();
        futureMap = new ConcurrentHashMap();
        poolSize = 2;
        daemon = Boolean.TRUE;
    }
}

