/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.winxin.util;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class XMLConverUtil {
    private static Logger logger = LoggerFactory.getLogger(XMLConverUtil.class);
    private static Map<Class<?>, JAXBContext> JAXB_CONTEXT_MAP = new ConcurrentHashMap(256);

    public static <T> T convertToObject(Class<T> clazz, String xml) {
        return XMLConverUtil.convertToObject(clazz, new StringReader(xml));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream, Charset charset) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream, charset));
    }

    public static <T> T convertToObject(Class<T> clazz, Reader reader) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            if (!JAXB_CONTEXT_MAP.containsKey(clazz)) {
                JAXB_CONTEXT_MAP.put(clazz, JAXBContext.newInstance((Class[])new Class[]{clazz}));
            }
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(reader));
            Unmarshaller unmarshaller = JAXB_CONTEXT_MAP.get(clazz).createUnmarshaller();
            return (T)unmarshaller.unmarshal((Source)xmlSource);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static String convertToXML(Object object) {
        try {
            if (!JAXB_CONTEXT_MAP.containsKey(object.getClass())) {
                JAXB_CONTEXT_MAP.put(object.getClass(), JAXBContext.newInstance((Class[])new Class[]{object.getClass()}));
            }
            Marshaller marshaller = JAXB_CONTEXT_MAP.get(object.getClass()).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new CharacterEscapeHandler(){

                public void escape(char[] ac, int i, int j, boolean flag, Writer writer) throws IOException {
                    writer.write(ac, i, j);
                }
            });
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> convertToMap(String xml) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            NodeList childNodes;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(xml);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            if (root != null && (childNodes = root.getChildNodes()) != null && childNodes.getLength() > 0) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (node == null || node.getNodeType() != 1) continue;
                    map.put(node.getNodeName(), node.getTextContent());
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return map;
    }
}

