/*
 * Decompiled with CFR 0.152.
 */
package emoji4j;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import emoji4j.AbstractEmoji;
import emoji4j.EmojiUtils;
import java.util.List;
import java.util.regex.Matcher;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Emoji
extends AbstractEmoji {
    private String emoji;
    private List<String> aliases;
    private String hexHtml;
    private String decimalHtml;
    private String decimalHtmlShort;
    private String hexHtmlShort;
    private String decimalSurrogateHtml;
    private List<String> emoticons;

    public String getEmoji() {
        return this.emoji;
    }

    public void setEmoji(String emoji) {
        this.setDecimalHtml(EmojiUtils.htmlifyHelper(emoji, false, false));
        this.setHexHtml(EmojiUtils.htmlifyHelper(emoji, true, false));
        this.setDecimalSurrogateHtml(EmojiUtils.htmlifyHelper(emoji, false, true));
        this.emoji = emoji;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public String getHexHtml() {
        return this.hexHtml;
    }

    public void setHexHtml(String hexHtml) {
        this.hexHtml = hexHtml;
        Matcher matcher = htmlSurrogateEntityPattern.matcher(hexHtml);
        if (matcher.find()) {
            String signifiantHtmlEntity = matcher.group("H");
            this.setHexHtmlShort(signifiantHtmlEntity);
        } else {
            this.setHexHtmlShort(hexHtml);
        }
    }

    public String getDecimalHtml() {
        return this.decimalHtml;
    }

    public void setDecimalHtml(String decimalHtml) {
        this.decimalHtml = decimalHtml;
        Matcher matcher = htmlSurrogateEntityPattern.matcher(decimalHtml);
        if (matcher.find()) {
            String signifiantHtmlEntity = matcher.group("H");
            this.setDecimalHtmlShort(signifiantHtmlEntity);
        } else {
            this.setDecimalHtmlShort(decimalHtml);
        }
    }

    public List<String> getEmoticons() {
        return this.emoticons;
    }

    public void setEmoticons(List<String> emoticons) {
        this.emoticons = emoticons;
    }

    public String getDecimalSurrogateHtml() {
        return this.decimalSurrogateHtml;
    }

    public void setDecimalSurrogateHtml(String decimalSurrogateHtml) {
        this.decimalSurrogateHtml = decimalSurrogateHtml;
    }

    public String getDecimalHtmlShort() {
        return this.decimalHtmlShort;
    }

    public void setDecimalHtmlShort(String decimalHtmlShort) {
        this.decimalHtmlShort = decimalHtmlShort;
    }

    public String getHexHtmlShort() {
        return this.hexHtmlShort;
    }

    public void setHexHtmlShort(String hexHtmlShort) {
        this.hexHtmlShort = hexHtmlShort;
    }
}

