package com.maila.biz.center.api.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 兑吧公共应用黑名单类型
 * @Author zhanghuifeng
 * @Date 16:29 2017/2/20
 */
public enum DuibaBlacklistRelationType {

	GOODS(1, "商品"), SPECIAL(2, "专场"), TAB(3 ,"tab") ,BANNER(4, "banner");
	private int id;

	private String name;

	DuibaBlacklistRelationType(int id, String name){
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	/**
	 * 根据id获取名称
	 *
	 * @param id
	 * @return
	 */
	public static String getNameById(final int id) {
		Collection<DuibaBlacklistRelationType> result = Collections2.filter(Arrays.asList(DuibaBlacklistRelationType.values()), gs -> gs.getId() == id);
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}
}
