package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦商家店铺类型
 * <p>
 * ClassName:MailaShopType
 * Date     : 2016年12月05日 16:25:41
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaShopType {

    TIANMAO(1, "天猫店"), ENTERPRISE(2, "企业店"), PERSONAL(3, "个人店");

    private int id;
    private String name;

    MailaShopType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<MailaShopType> result = Collections2.filter(Arrays.asList(MailaShopType.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

	/**
     * 转换成map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
