package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.MailaAppSkinDto;

/**
 * ClassName:RemoteMailaAppSkinBackendService
 * Date     : 2016年11月17日 19:01:22
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaAppSkinBackendService {

    /**
     * 添加皮肤
     *
     * @param mailaAppSkinDto
     * @return
     */
    DubboResult<BusinessMsgDto> insertSkin(MailaAppSkinDto mailaAppSkinDto);

    /**
     * 更新皮肤
     *
     * @param mailaAppSkinDto
     * @return
     */
    DubboResult<BusinessMsgDto> updateSkin(MailaAppSkinDto mailaAppSkinDto);


    /**
     *  根据app id获取皮肤
     *
     * @param appId
     * @return
     */
    DubboResult<MailaAppSkinDto> findById(Long appId);
}
