package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaSkinMarketDto;
import com.maila.biz.center.api.enums.MailaSkinTypeEnum;

import java.util.List;

/**
 * 麦啦皮肤市场后台服务类
 * ClassName:RemoteMailaSkinMarketBackendService
 * Date     : 2017年03月06日 11:59:14
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaSkinMarketBackendService {

    /**
     * 添加皮肤
     *
     * @param mailaSkinMarketDto
     * @return
     */
    DubboResult<Boolean> addSkin(MailaSkinMarketDto mailaSkinMarketDto);

    /**
     * 更新皮肤
     *
     * @param mailaSkinMarketDto
     * @return
     */
    DubboResult<Boolean> updateSkin(MailaSkinMarketDto mailaSkinMarketDto);

    /**
     * 根据皮肤id查询皮肤全属性
     *
     * @param skinId    皮肤id
     * @return
     */
    DubboResult<MailaSkinMarketDto> findById(Long skinId);


    /**
     * 根据皮肤id或皮肤名称查询皮肤,供下拉列表
     *
     * @param skinId    皮肤id
     * @param name      皮肤名称
     * @return
     */
    DubboResult<MailaSkinMarketDto> findByIdOrName4Select(Long skinId, String name);

    /**
     * 根据皮肤类型查询皮肤列表,供下拉列表
     *
     * @param skinType    皮肤类型  {@link MailaSkinTypeEnum}
     * @return
     */
    DubboResult<List<MailaSkinMarketDto>> findBySkinType4Select(Integer skinType);

    /**
     * 分页查询皮肤
     *
     * @param name        皮肤名称
     * @param skinType    皮肤类型  {@link MailaSkinTypeEnum}
     * @param offset      偏移量
     * @param pageSize    每页大小
     * @return
     */
    DubboResult<List<MailaSkinMarketDto>> findSkin4page(String name,Integer skinType, Integer offset, Integer pageSize);

    /**
     * 分页查询皮肤总数
     *
     * @param name        皮肤名称
     * @param skinType    皮肤类型  {@link MailaSkinTypeEnum}
     * @return
     */
    DubboResult<Integer> countSkin4page(String name,Integer skinType);
}
