package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaGoodsForAppDto;
import com.maila.biz.center.api.enums.DeveloperTypeEnum;

import java.util.List;

/**
 * 功能描述:为手机端提供关于专场接口
 *
 * @author sunchangji
 * @date 2016/11/11
 */
@AdvancedFeignClient
public interface RemoteMailaSpecialService {

	/**
	 * 根据应用id和专场id查询专场下所有商品
	 * @param appId 应用id
	 * @param specialId 专场id
	 * @return
	 */
	DubboResult<List<MailaGoodsForAppDto>> selectAppGoodsByAppIdAndSpecialId(Long appId,Long specialId);

	/**
	 * 获取专场排期结束时间
	 *
	 * @param appId 应用id
	 * @param specialId 专场id
	 * @return 排期结束时间的毫秒数:专场开关为ON:毫秒数，OFF:null
	 */
	DubboResult<Long> getSpecialScheduleEndTime(Long appId, Long specialId);

	/**
	 * 获取专场皮肤ID
	 * @param specialId  专场ID
	 * @param developerType 开发者应用类型
	 * @return Long
	 */
	DubboResult<Long> findSpecialSkinId(Long specialId, DeveloperTypeEnum developerType);
}
