package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.MailaCategoryTabGoodsDto;
import com.maila.biz.center.api.dto.MailaTabDto;
import com.maila.biz.center.api.dto.MailaTabGoodsAndSpecialDto;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * 功能描述:管理员后台tab api接口
 *
 * @author sunchangji
 * @date 2016/11/7
 */
@AdvancedFeignClient
public interface RemoteMailaTabBackendService {

	/**
	 * 新增
	 *
	 * @param mailaTabDto
	 * @return
	 */
	DubboResult<Long> insertMailaTab(MailaTabDto mailaTabDto);

	/**
	 * 更新
	 *
	 * @param mailaTabDto
	 * @return
	 */
	DubboResult<Boolean> updateMailaTab(MailaTabDto mailaTabDto);

	/**
	 * 更新tab启用禁用
	 * @param enable 1:启用，0:禁用
	 * @param id
	 * @return
	 */
	DubboResult<Boolean> updateEnable(Integer enable, Long id);

	/**
	 * 删除tab
	 *
	 * @param tabId
	 * @return
	 */
	DubboResult<Boolean> deleteMailaTabById(Long tabId);

	/**
	 * 根据应用id查询tab
	 *
	 * @param appId 应用id
	 * @return
	 */
	DubboResult<List<MailaTabDto>> selectAllEnableByAppId(Long appId);

	/**
	 * 批量更新tab顺序
	 *
	 * @param tabIdList
	 * @return
	 */
	DubboResult<Boolean> batchUpdateTabPayload(List<Long> tabIdList);

	/**
	 * 更新tab下商品或专场的顺序
	 *
	 * @param appId 应用id
	 * @param tabId
	 * @param idsStrList 专场或商品的id集合,形如:g35343,s8553
	 *                   g开头是商品,s开头是专场
	 * @return
	 */
	DubboResult<BusinessMsgDto> updateTabGoodsSpecialPayload(Long appId, Long tabId,List<String> idsStrList);

	/**
	 * 查询应用下某一个tab下商品或者专场的列表数据
	 * @param appId
	 * @param tabId
	 * @param pageStart
	 * @param pageSize
     * @return
     */
	DubboResult<List<MailaTabGoodsAndSpecialDto>> selectGoodsSpecialByTabId(Long appId, Long tabId, Integer pageStart, Integer pageSize);

	/**
	 * 根据中间表id删除tab与商品专场中间表记录
	 *
	 * @param tabGoodsRelationId 商品专场中间表id
	 * @return
	 */
	DubboResult<Boolean> deleteRelationByRelationId(Long tabGoodsRelationId);

	/**
	 * 删除tab下已下架商品或专场中间表记录
	 *
	 * @param appId 应用id
	 * @param tabId
	 * @return
	 */
	DubboResult<Boolean> deleteByTabIdAndRelationStatus(Long appId, Long tabId);

	/**
	 * 批量新增tab下商品或者专场关联关系
	 *
	 * @param appId 应用id
	 * @param tabId
	 * @param type 类型(2:商品,3:专场)
	 * @param relationIds (type为2则为商品Id集合,为3则为专场id集合)
	 * @return
	 */
	DubboResult<Boolean> batchInsertTabGoodsRelation(Long appId, Long tabId, Integer type, List<Long> relationIds);

	/**
	 * 批量添加一个商品到多个tab里
	 *
	 * @param goodsId   商品id
	 * @param tabIdList tab id集合
	 * @return
	 */
	@RequestMapping("batchInsertTabGoodsRelation1")
	DubboResult<Boolean> batchInsertTabGoodsRelation(Long goodsId, List<Long> tabIdList);

	/**
	 *  源tab中的商品（包含排序）复制至目标tab下
	 *
	 * @param appId      应用id
	 * @param origTabId  源tabId
	 * @param destTabIds 目标tabId集
	 * @return
	 */
	DubboResult<Boolean> copyTab(Long appId, Long origTabId, List<Long> destTabIds);


	/**
	 * 类目tab下的内容（目前只有商品）置顶
	 *
	 * @param appId            应用id
	 * @param tabId            tabId
	 * @param contentIds       置顶内容id字符串，例：1,2,3,4
	 * @return
	 */
	DubboResult<BusinessMsgDto> categoryTabTop(Long appId, Long tabId, List<Long> contentIds);

	/**
	 * 类目tab下的内容（目前只有商品）取消置顶
	 *
	 * @param appId            应用id
	 * @param tabId            tabId
	 * @param contentIds       置顶内容id字符串，例：1,2,3,4
	 * @return
	 */
	DubboResult<Boolean> categoryTabCancelTop(Long appId, Long tabId, List<Long> contentIds);

	/**
	 * 查询类目tab下的商品列表
	 *
	 * @param appId      应用id
	 * @param tabId      tabId
	 * @param id         当前页最后一条数据的商品记录id
	 * @param pageSize   每页条数
	 * @return
	 */
	DubboResult<List<MailaCategoryTabGoodsDto>> findCategoryGoodsList(Long appId, Long tabId, Long id, Integer pageSize);
}
