package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaThirdpartyAppGoodsDto;

import java.util.List;

/**
 * Created by johnkeng on 2017/3/23.
 */
@AdvancedFeignClient
public interface RemoteMailaThirdpartyAppBackendService {

    /**
     * 麦拉第三方应用商品分页 模糊 查询
     *
     * @param appId
     * @param itermId
     * @param searchInfo
     * @param goodAuditStatus
     * @param pageStart
     * @param pageSize
     * @return
     */
    public DubboResult<List<MailaThirdpartyAppGoodsDto>> selectThirdpartyGoodsInfo(Long appId, Long itermId, String searchInfo,
                                                                                   Integer goodAuditStatus, Integer pageStart, Integer pageSize);

    /**
     * 查询麦拉 分页查询总数据条数
     * @param appId
     * @param itermId
     * @param searchInfo
     * @param goodAuditStatus
     * @return
     */
    public DubboResult<Long> countForSelectPages(Long appId, Long itermId, String searchInfo, Integer goodAuditStatus);

    /**
     * 更新第三方应用商品信息
     *
     * @param appId
     * @param goodsIds
     * @return
     */
    public DubboResult<List<MailaThirdpartyAppGoodsDto>> refreshGoodsInfo(Long appId, List<Long> goodsIds);

    /**
     * 获取驳回信息
     *
     * @param appId
     * @param goodsId
     * @return
     */
    public DubboResult<String> getMsg(Long appId, Long goodsId);
}
