package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.MailaThirdpartyGoodsDto;
import com.maila.biz.center.api.dto.MailaThirdpartyGoodsStatusDto;
import com.maila.biz.center.api.dto.query.MailaThirdpartyGoodsQryDto;

/**
 * 管理员后台麦啦第三方商品库
 * @Author zhanghuifeng
 * @Date 17:37 2017/3/6
 */
@AdvancedFeignClient
public interface RemoteMailaThirdpartyGoodsBackendService {

	/**
	 * 批量插入第三方商品库
	 * @param list
	 * @return
	 */
	DubboResult<Boolean> batchInsertThirdpartyGoods(List<MailaThirdpartyGoodsDto> list);

	/**
	 * 根据条件分页查询第三方商品库
	 * @param qryDto
	 * @return
	 */
	DubboResult<List<MailaThirdpartyGoodsDto>> findByConditionPage(MailaThirdpartyGoodsQryDto qryDto);

	/**
	 * 根据条件分页查询第三方商品库数
	 * @param qryDto
	 * @return
	 */
	DubboResult<Long> countFindByConditionPage(MailaThirdpartyGoodsQryDto qryDto);

	/**
	 * 根据第三方商品库商品淘宝ID集合查询存在的itemID集合
	 * @param itemIds 淘宝商品ID集合
	 * @return 淘宝商品ID集合
	 */
	DubboResult<List<Long>> findByItemIds(List<Long> itemIds);

	/**
	 * 首次插入所有大淘客商品到第三方商品库
	 * @param list
	 * @return
	 */
	DubboResult<Boolean> insertAllDaTaoKeGoods(List<MailaThirdpartyGoodsDto> list);

	/**
	 * 更新
	 * @param dto
	 * @return
	 */
	DubboResult<Boolean> update(MailaThirdpartyGoodsDto dto);

	/**
	 * 单个第三方商品库入主库
	 * @param goodsDto
	 * @return
	 */
	DubboResult<MailaThirdpartyGoodsStatusDto> pushIntoGoods(MailaThirdpartyGoodsDto goodsDto);

	/**
	 * 批量第三方商品库入主库
	 * @param goodsList
	 * @return
	 */
	DubboResult<List<MailaThirdpartyGoodsStatusDto>> batchPushIntoGoods(List<MailaThirdpartyGoodsDto> goodsList);

	/**
	 * 根据第三方商品库主键查询商品
	 * @param id   主键ID
	 * @return
	 */
	DubboResult<MailaThirdpartyGoodsDto> findById(Long id);

	/**
	 * 批量查询第三方商品库
	 * @param ids  商品主键ID集合
	 * @return
	 */
	DubboResult<List<MailaThirdpartyGoodsDto>> batchFindByIds(List<Long> ids);

	/**
	 * 批量第三方商品库入主库
	 * @param goodsList
	 * @return
	 */
	DubboResult<Boolean> batchChangeCategory(List<MailaThirdpartyGoodsDto> goodsList);
}
