package com.maila.biz.center.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.*;
import com.maila.biz.center.api.dto.app.Maila88AppDto;
import com.maila.biz.center.api.dto.app.Maila88AppSelectDto;
import com.maila.biz.center.api.dto.app.Maila88AppSkinInfoDto;
import com.maila88.common.dto.Maila88PageDto;

import java.util.List;

/**
 * Created by peanuthuang on 2017/4/20.
 *
 * 已过时,不要再使用
 */
@AdvancedFeignClient
public interface RemoteMaila88AppBackendService {

    /**
     * 注册麦啦app
     *
     * @param mailaAppDto
     * @return
     */
    DubboResult<BusinessMsgDto> insert(Maila88AppDto mailaAppDto);

    /**
     * 更新麦啦app
     *
     * @param mailaAppDto
     * @return
     */
    DubboResult<BusinessMsgDto> update(Maila88AppDto mailaAppDto);


    /**
     * 根据id查询app
     *
     * @param appId
     * @return
     */
    DubboResult<Maila88AppDto> findById(Long appId);


    /**
     * 分页查找所有app
     *
     * @param name          应用名称
     * @param appId         应用id
     * @param currentPage
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88AppDto>> find4Page(String name, Long appId, Integer currentPage, Integer pageSize);

    /**
     * 查找所有应用，供下拉列表
     *
     * @param appId  应用id
     * @param name   应用名称
     * @return
     */
    DubboResult<List<Maila88AppSelectDto>> find4Select(Long appId, String name);

    /**
     * 根据应用id获取应用皮肤信息
     *
     * @param appId   应用id
     * @return
     */
    DubboResult<Maila88AppSkinInfoDto> findSkinInfo(Long appId);

    /**
     * 更新应用皮肤信息
     *
     * @param appSkinInfoDto
     * @return
     */
    DubboResult<Boolean> updateSkinInfo(Maila88AppSkinInfoDto appSkinInfoDto);
}
