package com.maila.biz.center.api.remoteservice.merchants;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.MailaThirdpartyGoodsDto;
import com.maila.biz.center.api.dto.MailaThirdpartyGoodsStatusDto;
import com.maila.biz.center.api.dto.merchants.Maila88ThirdpartyGoodsDto;
import com.maila.biz.center.api.dto.merchants.Maila88ThirdpartyGoodsQryDto;
import com.maila88.common.dto.Maila88PageDto;

/**
 * 管理员后台麦啦第三方商品库
 * Author zhanghuifeng
 * Date 17:37 2017/4/24
 */
@AdvancedFeignClient
public interface RemoteMaila88ThirdpartyGoodsBackendService {

	/**
	 * 批量插入第三方商品库
	 * @param list list
	 * @return Boolean
	 */
	DubboResult<Boolean> batchInsertThirdpartyGoods(List<Maila88ThirdpartyGoodsDto> list);

	/**
	 * 根据条件分页查询第三方商品库
	 * @param qryDto 查询参数
	 * @return Maila88PageDto<Maila88ThirdpartyGoodsDto>
	 */
	DubboResult<Maila88PageDto<Maila88ThirdpartyGoodsDto>> findByConditionPage(Maila88ThirdpartyGoodsQryDto qryDto);

	/**
	 * 根据第三方商品库商品淘宝ID集合查询存在的itemID集合
	 * @param itemIds 淘宝商品ID集合
	 * @return 淘宝商品ID集合
	 */
	DubboResult<List<Long>> findByItemIds(List<Long> itemIds);

	/**
	 * 更新
	 * @param dto 参数
	 * @return boolean
	 */
	DubboResult<Boolean> update(Maila88ThirdpartyGoodsDto dto);

	/**
	 * 单个第三方商品库入主库
	 * @param goodsDto 参数
	 * @return
	 */
	DubboResult<MailaThirdpartyGoodsStatusDto> pushIntoGoods(MailaThirdpartyGoodsDto goodsDto);

	/**
	 * 批量第三方商品库入主库
	 * @param goodsList
	 * @return
	 */
	DubboResult<List<MailaThirdpartyGoodsStatusDto>> batchPushIntoGoods(List<MailaThirdpartyGoodsDto> goodsList);

	/**
	 * 根据第三方商品库主键查询商品
	 * @param id   主键ID
	 * @return Maila88ThirdpartyGoodsDto
	 */
	DubboResult<Maila88ThirdpartyGoodsDto> findById(Long id);

	/**
	 * 批量查询第三方商品库
	 * @param ids  商品主键ID集合
	 * @return List<Maila88ThirdpartyGoodsDto>
	 */
	DubboResult<List<Maila88ThirdpartyGoodsDto>> batchFindByIds(List<Long> ids);
}
