package com.maila88.modules.activity.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 组件类型
 *
 * Created by peanut.huang on 2017/9/7.
 */
public enum Maila88ModuleTypeEnum {

    /**
     *  自由热区
     */
    HOT_POSITION(1, "自由热区"),

    GOODS_AREA(2, "商品区"),

    COUNT_DOWN(3, "倒计时");


    private int id;

    private String desc;


    Maila88ModuleTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    public static Maila88ModuleTypeEnum findById(Integer id){
        if(id == null){
            return null;
        }
        return Arrays.stream(Maila88ModuleTypeEnum.values()).filter(e -> id.equals(e.getId())).findFirst().orElse(null);
    }


    /**
     * 存入Map
     *
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getDesc());
        map.put("id", getId());
        return map;
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}
