package com.maila88.modules.activity.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.modules.activity.dto.Maila88ActivityGoodsAreaDto;
import com.maila88.modules.activity.dto.Maila88ActivityGoodsDto;

import java.util.List;

/**
 * 活动商品后台服务
 *
 * Created by peanut.huang on 2017/9/7.
 */
@AdvancedFeignClient
public interface RemoteMaila88ActivityGoodsBackendService {

    /**
     * 列出活动下的商品区域
     *
     * @param activityId 活动id
     * @return
     */
     List<Maila88ActivityGoodsAreaDto> listGoodsArea(Long activityId);

    /**
     * 列出活动商品区域下的商品列表，不分页
     *
     * @param activityId         活动id
     * @param activityModuleId   商品区组件在活动中的id
     * @return
     */
     List<Maila88ActivityGoodsDto> listGoods(Long activityId, Long activityModuleId);

    /**
     * 移除活动商品区商品
     *
     * @param activityId           活动id
     * @param activityModuleId     商品区组件在活动中的id
     * @param delGoodsIds          要移除的商品id集
     * @return
     */
     Boolean removeGoods(Long activityId, Long activityModuleId, List<Long> delGoodsIds);

    /**
     * 移除活动商品区已失效的商品
     *
     * @param activityId           活动id
     * @param activityModuleId     商品区组件在活动中的id
     * @return
     */
     Boolean removeInvalidGoods(Long activityId, Long activityModuleId);

    /**
     * 批量排序活动商品区内的商品
     *
     * <p> 将过滤sortedGoodsIds中失效或不存在的商品id</p>
     *
     * @param activityId           活动id
     * @param activityModuleId     商品区组件在活动中的id
     * @param sortedGoodsIds       已排序好的有序商品id集
     * @return
     */
     Boolean batchSortGoods(Long activityId, Long activityModuleId, List<Long> sortedGoodsIds);

    /**
     * 活动商品区批量插入商品
     *
     * <p> 将过滤insertGoodsIds中已失效和已经存在于商品区的商品 </p>
     *
     * @param activityId           活动id
     * @param activityModuleId     商品区组件在活动中的id
     * @param insertGoodsIds       待插入的商品
     * @return
     */
     Boolean batchInsertGoods(Long activityId, Long activityModuleId, List<Long> insertGoodsIds);
}
