package com.maila88.modules.apporder.dto;

import java.io.Serializable;

/**
 * 管理端修改订单状态信息
 *
 * Created by sunchangji on 2017/10/12.
 */
public class Maila88UpdateJqgOrderDto implements Serializable{
    private static final long serialVersionUID = 7585995368608421659L;
    /**
     * 订单主键id
     */
    private Long id;

    /**
     * 商品主图
     */
    private String auctionPictUrl;

    /**
     * 商品标题
     */
    private String auctionTitle;

    /**
     * 单个商品支付金额
     */
    private Long realPay;

    /**
     * 订单状态,7:创建订单;6:交易成功确认收货;2:付款成功(下单已付款);
     * 4：退款后交易关闭；8：创建订单后交易关闭
     */
    private Integer orderStatus;

	/**
	 * 麦啦订单目前状态,1:提交中,2:待付款,3:待入账,4:已入账,5:已失效
     */
    private Integer currentStatus;

    /**
     * 店铺名称
     */
    private String shopTitle;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAuctionPictUrl() {
        return auctionPictUrl;
    }

    public void setAuctionPictUrl(String auctionPictUrl) {
        this.auctionPictUrl = auctionPictUrl;
    }

    public String getAuctionTitle() {
        return auctionTitle;
    }

    public void setAuctionTitle(String auctionTitle) {
        this.auctionTitle = auctionTitle;
    }

    public Long getRealPay() {
        return realPay;
    }

    public void setRealPay(Long realPay) {
        this.realPay = realPay;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getShopTitle() {
        return shopTitle;
    }

    public void setShopTitle(String shopTitle) {
        this.shopTitle = shopTitle;
    }

    public Integer getCurrentStatus() {
        return currentStatus;
    }

    public void setCurrentStatus(Integer currentStatus) {
        this.currentStatus = currentStatus;
    }
}
