package com.maila88.modules.apporder.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.apporder.dto.Maila88JqgOrderDto;
import com.maila88.modules.apporder.dto.Maila88UserAccumIncomeDto;
import com.maila88.modules.apporder.dto.Maila88UserSumConsumeDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/9/12.
 */
@AdvancedFeignClient
public interface RemoteMaila88AppOrderService {

    /**
     * 根据订单状态查询用户订单
     *
     * @param jqgUserId     麦啦应用用户id
     * @param tbOrderStatus 淘宝订单状态集合
     * @return
     */
    DubboResult<List<Maila88JqgOrderDto>> findByJqgUserIdAndStatus(Long jqgUserId, List<Integer> tbOrderStatus, Integer offset, Integer pageSize);

    /**
     * 匹配用户上报的订单号
     *
     * @param appId         应用id
     * @param jqgUserId     用户id
     * @param orderId       父订单号
     * @return
     */
    DubboResult<List<Maila88JqgOrderDto>> matchUserOrder(Long appId, Long jqgUserId, String orderId);

    /**
     * 根据订单主键id查询订单
     * @param id
     * @return
     */
    Maila88JqgOrderDto findByIdAndJqgUserId(Long id,Long jqgUserId);

    /**
     * 查询用户总消费金相关数据
     *
     * @param jqgUserId
     * @return
     */
    Maila88UserSumConsumeDto findUserSumConsume(Long jqgUserId);

    /**
     * 查询用户总收益和30天每日收益详情数据
     *
     * @param jqgUserId 用户id
     * @return
     */
    Maila88UserAccumIncomeDto findUserAccumIncome(Long jqgUserId);
}
