package com.maila88.modules.apporder.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.apporder.dto.Maila88JqgOrderGoodsDto;
import com.maila88.modules.apporder.dto.Maila88MangerJqgOrderDto;
import com.maila88.modules.apporder.dto.Maila88UpdateJqgOrderDto;
import com.maila88.modules.apporder.param.Maila88JqgOrderQryBean;

/**
 * Created by sunchangji on 2017/10/11.
 */
@AdvancedFeignClient
public interface RemoteMaila88JqgOrderBackendService {

    /**
     * 根据条件查询订单数据信息
     *
     * @param jqgOrderQryBean 查询订单参数
     * @return Maila88PageDto<Maila88MangerJqgOrderDto>
     */
    Maila88PageDto<Maila88MangerJqgOrderDto> findPageOrderList(Maila88JqgOrderQryBean jqgOrderQryBean);

    /**
     * 根据id查询订单信息
     *
     * @param id 订单表主键id
     * @return
     */
    Maila88JqgOrderGoodsDto findGoodsOrderById(Long id,int orderStatus);

    /**
     * 人工修改订单状态和订单的信息
     *
     * @param updateJqgOrderDto
     * @return
     */
    boolean updateOrderStatus(Maila88UpdateJqgOrderDto updateJqgOrderDto);

    /**
     * 手动修复没有上报淘宝用户id的用户记录
     *
     * @param account 淘宝用户昵称
     * @param openId  淘宝用户id
     * @return Maila88BusinessMsgDto<String>
     */
    Maila88BusinessMsgDto<String> repairJqgUserOpenId(String account, Long openId);

    /**
     * 手动修复没有上报淘宝用户id的用户记录
     *
     * @param orderId     父订单id
     * @param account     淘宝用户昵称
     * @param strongCheck true:强校验,false:不校验
     * @return Maila88BusinessMsgDto<String>
     */
    Maila88BusinessMsgDto<String> repairJqgUserOrder(String orderId, String account, boolean strongCheck);
}
