package com.maila88.modules.appuser.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.appuser.dto.Maila88JqgUserDto;
import com.maila88.modules.appuser.dto.Maila88UserIncomeDto;
import com.maila88.modules.appuser.param.Maila88JqgUserParam;

/**
 * Created by gyf .
 * 2017/9/12 .
 */
@AdvancedFeignClient
public interface RemoteMaila88JqgUserService {

    /**
     * app 登录接口
     *
     * @param userParam
     * @return
     */
    DubboResult<Maila88JqgUserDto> applogin(Maila88JqgUserParam userParam);

    /**
     * 淘宝信息更新
     *
     * @param appId
     * @param taobaoNick
     * @param und
     * @return
     */
    DubboResult<Boolean> updateTaobaoUnd(Long appId, String taobaoNick, Long und);

    /**
     * 获取用户收益相关数据
     *
     * @param jqgUserId 用户id
     * @return
     */
    Maila88UserIncomeDto findUserIncomeData(Long jqgUserId);
}
