package com.maila88.modules.coupon.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.coupon.dto.Maila88CouponInfoDto;

/**
 * Created by sunchangji on 2017/7/19.
 */
@AdvancedFeignClient
public interface RemoteMaila88CouponInfoBackendService {

    /**
     * 分页查找未核对记录
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88CouponInfoDto>> findNoChecked(int offset, int pageSize);

    /**
     * 分页查找系统自动下线和已核对下线记录
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88CouponInfoDto>> findCheckedAndAutoOffline(int offset, int pageSize);

    /**
     * 运营审核操作,监控错误的直接从监控优惠券表中删除,继续监控
     * @param id 主键id
     * @param offline true:手动下架,false:监控错误
     * @return
     */
     DubboResult<Boolean> changeChecked(Long id,boolean offline);
}
