package com.maila88.modules.data.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila88.modules.data.dto.Maila88BehavioralRuleDto;

/**
 * 用户行为规则
 * Author: zhanghuifeng
 * Date:   16:07 2017/7/21
 */
@AdvancedFeignClient
public interface RemoteMaila88BehavioralRuleBackendService {

	/**
	 * 获取所有用户行为规则
	 * @return 集合
	 */
	DubboResult<List<Maila88BehavioralRuleDto>> findAll();

	/**
	 * 删除
	 * @param id ID
 	 * @return boolean
	 */
	DubboResult<Boolean> delete(Long id);

	/**
	 * 更新
	 * @param dto 用户行为数据
	 * @return boolean
	 */
	DubboResult<Boolean> update(Maila88BehavioralRuleDto dto);

	/**
	 * 插入
	 * @param dto 用户行为数据
	 * @return boolean
	 */
	DubboResult<Boolean> insert(Maila88BehavioralRuleDto dto);
}
