package com.maila88.modules.floor.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.floor.dto.Maila88AppFloorDto;

import java.util.List;

/**
 * Created by peanuthuang on 2017/5/17.
 */
@AdvancedFeignClient
public interface RemoteMaila88AppFloorBackendService {

    /**
     * 根据应用id查询应用使用的楼层
     *
     * @param appId  应用id
     * @return
     */
    DubboResult<List<Maila88AppFloorDto>> findByAppId(Long appId);

    /**
     * 保存或更新 app与楼层关联表
     * @param maila88AppFloorDtoList
     * @return
     */
    DubboResult<Boolean> saveOrUpdateFloorInfo(List<Maila88AppFloorDto> maila88AppFloorDtoList);

    /**
     * 根据应用id 查询皮肤url
     * @param appId
     * @return
     */
    DubboResult<String> getAppFloorSkinById(Long appId);

    /**
     * 根据floorId 删除
     * @param floorId
     * @return
     */
    DubboResult<Boolean> deleteByFloorId(Long floorId);
}
