package com.maila88.modules.goods.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 麦啦商品类型
 */
public enum Maila88GoodsTypeEnum {

    TAOBAO_ITEM_ID(1, "专享价"),
    URL(2, "优惠券"),
    CASH_ON_DELIVERY(3, "货到付款"),
    MARKETING_PLAN(4,"新优惠券");//营销计划类型商品

    private int    value;
    private String name;

    Maila88GoodsTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }
    public static String getByValue(final int value) {
        Collection<Maila88GoodsTypeEnum> result = Collections2.filter(Arrays.asList(Maila88GoodsTypeEnum.values()), gs -> gs.getValue() == value);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }
    /**
     * 判断是否是已存在的GoodsPlanType
     *
     * @param id id
     * @return
     */
    public static boolean isGoodsPlanType(int id) {
        boolean flag = false;
        switch (id) {
            case 1:
            case 2:
                flag = true;
                break;
            default:
                break;
        }
        return flag;
    }
}

