package com.maila88.modules.jqgapp.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.jqgapp.dto.Maila88JqgAppVersionDto;
import com.maila88.modules.jqgapp.param.Maila88JqgAppVersionQryBean;

/**
 * Created by sunchangji on 2017/9/22.
 */
@AdvancedFeignClient
public interface RemoteMaila88JqgAppVersionBackendService {

    /**
     * 分页查询版本信息记录
     *
     * @param appVersionQryBean
     * @param offset
     * @param pageSize
     * @return
     */
    Maila88PageDto<Maila88JqgAppVersionDto> findPageList(Maila88JqgAppVersionQryBean appVersionQryBean, int offset, int pageSize);

    /**
     * 新增版本信息记录
     *
     * @param jqgAppInfoDto
     * @return
     */
    Boolean insertAppVersion(Maila88JqgAppVersionDto jqgAppInfoDto);

    /**
     * 更新应用版本信息
     *
     * @param jqgAppInfoDto
     * @return
     */
    Boolean updateAppVersion(Maila88JqgAppVersionDto jqgAppInfoDto);


    /**
     * 删除版本记录
     *
     * @param id
     * @return
     */
    Boolean deleteAppVersion(Long id);


    /**
     * 根据id查询记录
     *
     * @param id
     * @return
     */
    Maila88JqgAppVersionDto findById(Long id);

}
